/*
    module/dt2817.c
    hardware driver for Data Translation DT2817

    COMEDI - Linux Control and Measurement Device Interface
    Copyright (C) 1998 David A. Schleef <ds@stm.lbl.gov>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/timex.h>
#include <linux/timer.h>
#include <asm/io.h>
#include <comedi_module.h>



#define DT2817_SIZE 5

#define DT2817_CR 0
#define DT2817_DATA 1


comedi_devinit dt2817_init;
static int dt2817_rem(comedi_device *dev);

static int dt2817_dio(comedi_device *dev,comedi_subdevice *s,comedi_trig *it)
{
	int chan=CR_CHAN(it->chanlist[0]);

	it->data[0]=inb(dev->iobase+DT2817_DATA+chan);
	
	return 1;
#if 0
	outb(it->data,dev->iobase+DT2817_DATA+it->chan);
#endif
}

#if 0
static int dt2817_sp(comedi_device *dev,comedi_param *it)
{
	switch(it->pnum){
	case COMEDI_IOBITS:
		switch(it->pval){
		case 0xff&COMEDI_IOBITS_INPUT:
			devpriv->cr &= (~(1<<it->chan));
			break;
		case 0xff&COMEDI_IOBITS_OUTPUT:
			devpriv->cr |= (1<<it->chan);
			break;
		default:
			return -EINVAL;
		}
		outb(devpriv->cr,dev->iobase+DT2817_CR);
		changeparam(&dev->chinfo[it->chan].paramlist,COMEDI_IOBITS,0,
			it->pval);
		return 0;
	default:
		return -EINVAL;
	}
}
#endif

int dt2817_init(comedi_device *dev,comedi_devconfig *it)
{
	int ret;
	comedi_subdevice *s;

	if(strcmp("dt2817",it->board_name))
		return 0;

	dev->iobase=it->options[0];
	printk("comedi%d: dt2817: 0x%04x ",dev->minor,dev->iobase);
	if(check_region(dev->iobase,DT2817_SIZE)<0){
		printk("I/O port conflict\n");
		return -EIO;
	}
	request_region(dev->iobase,DT2817_SIZE,"dt2817");
	dev->board_name="dt2817";
	dev->driver_name="dt2817";
	dev->iosize=DT2817_SIZE;

	dev->n_subdevices=1;
	if((ret=alloc_subdevices(dev))<0)
		return ret;

	s=dev->subdevices+0;

	s->n_chan=32;
	s->type=COMEDI_SUBD_DIO;
	s->subdev_flags=SDF_READABLE|SDF_WRITEABLE;
	s->range_type=RANGE_digital;
	s->maxdata=1;
	s->trig[0]=dt2817_dio;

	s->state=0;
	outb(s->state,dev->iobase+DT2817_CR);

	dev->rem=dt2817_rem;
	printk("\n");

	return 1;
}


static int dt2817_rem(comedi_device *dev)
{
	printk("comedi%d: dt2817: remove\n",dev->minor);
	
	kfree(dev->subdevices);
	release_region(dev->iobase,dev->iosize);

	return 0;
}

