/*
 * dummy driver
 * David A. Schleef
 */

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/timex.h>
#include <linux/timer.h>
#include <asm/io.h>
#include <comedi_module.h>

/* this structure is for data unique to this hardware driver.  If
   several hardware drivers keep similar information in this structure,
   feel free to suggest moving the variable to the comedi_device struct.  */
typedef struct{
	int data;
}dummy_private;
#define devpriv ((dummy_private *)dev->private)

comedi_devinit dummy_init;
static int dummy_rem(comedi_device *dev);

static int dummy_ai(comedi_device *dev,comedi_subdevice *s,comedi_trig *it);
static int dummy_ao(comedi_device *dev,comedi_subdevice *s,comedi_trig *it);

int dummy_init(comedi_device *dev,comedi_devconfig *it)
{
	comedi_subdevice *s;

/* there is a *_init() function for each hardware driver installed.
   Each one is called in sequence.
   if it->name is a device that this hardware driver supports, we try
   to initialize it.  If everything works, return a 1.  If there is
   an error, return the error.  If we do not match it->name, return a
   0 so that the next *_init() function can be tried. */

/* *dev is zeroed except for dev->minor, which contains the minor
   number being used.  *it has configuration information (not really
   used here--see other drivers.)  this function is responsible for
   filling the rest of *dev. */

#if DEBUG
	printk("testing dummy\n");
#endif
	if(strcmp("dummy",it->board_name)){
#if DEBUG
		printk("tested false\n");
#endif
		return 0;
	}

#if DEBUG
	printk("tested ok\n");
#endif
	printk("comedi%d: dummy: ",dev->minor);
	
	/* this is an appropriate place to put probe and initialization
	   code.  remember to fill in dev->iobase and friends. */
	dev->board_name="dummy";
	dev->driver_name="dummy";

	dev->private=kmalloc(sizeof(dummy_private),GFP_KERNEL);
	if(!dev->private)return -ENOMEM;
#if DEBUG
	printk("malloc ok\n");
#endif
	memset(dev->private,0,sizeof(dummy_private));
#if DEBUG
	printk("memset ok\n");
#endif
	dev->n_subdevices=2;
	
	dev->subdevices=kmalloc(2*sizeof(comedi_subdevice),GFP_KERNEL);
	if(!dev->subdevices)return -ENOMEM;
	memset(dev->subdevices,0,2*sizeof(comedi_subdevice));

	/* analog input subdevice */
	s=dev->subdevices+0;
	s->type=COMEDI_SUBD_AI;
	s->subdev_flags=SDF_READABLE;
	s->n_chan=1;
	s->maxdata=0xffff;
	s->range_type=RANGE_unknown;
	s->trig[0]=dummy_ai;
	
	/* analog output subdevice */
	s=dev->subdevices+1;
	s->type=COMEDI_SUBD_AO;
	s->subdev_flags=SDF_WRITEABLE;
	s->n_chan=1;
	s->maxdata=0xffff;
	s->range_type=RANGE_unknown;
	s->trig[0]=dummy_ao;
	
	dev->rem=dummy_rem;

	return 1;
}


static int dummy_rem(comedi_device *dev)
{
	printk("comedi%d: dummy: remove\n",dev->minor);
	
	kfree(dev->private);
	kfree(dev->subdevices);

	return 0;
}

static int dummy_ai(comedi_device *dev,comedi_subdevice *s,comedi_trig *it)
{
	it->data[0]=devpriv->data;

	return 0;
}

static int dummy_ao(comedi_device *dev,comedi_subdevice *s,comedi_trig *it)
{
	devpriv->data=it->data[0];

	return 0;
}

