/*
    module/dt3000.c
    Data Translation DT3000 series driver

    COMEDI - Linux Control and Measurement Device Interface
    Copyright (C) 1999 David A. Schleef <ds@stm.lbl.gov>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


#define PCI_VENDOR_ID_DT	0x1116

typedef struct{
	char *name,
	unsigned int pci_board_id,
}dt3k_boardtype;

static dt3k_boardtype dt3k_boardtypes[]={
	{	"dt3001-pgl"
		0x27
	},
	{	"dt3003-pgl",
		0x28
	},
	{	"dt3003",
		0x24
	},
	{	"dt3002",
		0x23
	},
	{	"dt3001",
		0x22
	},
	{	"dt3004",
		0x25
	},
	{	"dt3005",
		0x26
	},
};

#define DPR_DAC_buffer		0x000
#define DPR_ADC_buffer		0x800
#define DPR_Command		0xfd3
#define DPR_Tick_Reg_Lo		0xff5
#define DPR_Tick_Reg_Hi		0xff6
#define DPR_DA_Buf_Front	0xff7
#define DPR_DA_Buf_Rear		0xff8
#define DPR_AD_Buf_Front	0xff9
#define DPR_AD_Buf_Rear		0xffa
#define DPR_Int_Mask		0xffb
#define DPR_Intr_Flag		0xffc
#define DPR_Response_Mbx	0xffe
#define DPR_Command_Mbx		0xfff

