/*
 * Driver for PCL725 and clones
 * David A. Schleef
 */

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/timex.h>
#include <linux/timer.h>
#include <asm/io.h>
#include <comedi_module.h>



#define PCL725_SIZE 2

#define PCL725_DO 0
#define PCL725_DI 1

comedi_devinit pcl725_init;
static int pcl725_do(comedi_device *dev,comedi_subdevice *s,comedi_trig *it);
static int pcl725_di(comedi_device *dev,comedi_subdevice *s,comedi_trig *it);
static int pcl725_rem(comedi_device *dev);

static int pcl725_do(comedi_device *dev,comedi_subdevice *s,comedi_trig *it)
{
	outb(dev->iobase+PCL725_DO,it->data[0]);
	return 0;
}

static int pcl725_di(comedi_device *dev,comedi_subdevice *s,comedi_trig *it)
{
	it->data[0]=inb(dev->iobase+PCL725_DI);
	
	return 0;
}

int pcl725_init(comedi_device *dev,comedi_devconfig *it)
{
	comedi_subdevice *s;

	if(strcmp("pcl725",it->board_name))
		return 0;

	dev->iobase=it->options[0];
	printk("comedi%d: pcl725: 0x%04x ",dev->minor,dev->iobase);
	if(check_region(dev->iobase,PCL725_SIZE)<0){
		printk("I/O port conflict\n");
		return -EIO;
	}
	request_region(dev->iobase,PCL725_SIZE,"pcl725");
	dev->driver_name="pcl725";
	dev->board_name="pcl725";
	dev->iobase=dev->iobase;
	dev->iosize=PCL725_SIZE;
	dev->irq=0;

	dev->n_subdevices=2;

	dev->subdevices=kmalloc(dev->n_subdevices*sizeof(comedi_subdevice),GFP_KERNEL);
	if(!dev->subdevices)
		return -ENOMEM;
	memset(dev->subdevices,0,dev->n_subdevices*sizeof(comedi_subdevice));

	s=dev->subdevices+0;
	/* do */
	s->type=COMEDI_SUBD_DO;
	s->subdev_flags=SDF_WRITEABLE;
	s->maxdata=1;
	s->n_chan=8;
	s->trig[0]=pcl725_do;
	s->range_type=RANGE_digital;

	s=dev->subdevices+1;
	/* do */
	s->type=COMEDI_SUBD_DI;
	s->subdev_flags=SDF_READABLE;
	s->maxdata=1;
	s->n_chan=8;
	s->trig[0]=pcl725_di;
	s->range_type=RANGE_digital;

	dev->rem=pcl725_rem;
	printk("\n");

	return 1;
}


static int pcl725_rem(comedi_device *dev)
{
	printk("comedi%d: pcl725: remove\n",dev->minor);
	
	kfree(dev->subdevices);
	release_region(dev->iobase,dev->iosize);

	return 0;
}

