/*
    module/comeditypes.c
    routine that calls all initialization functions

    COMEDI - Linux Control and Measurement Device Interface
    Copyright (C) 1998 David A. Schleef <ds@stm.lbl.gov>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/fcntl.h>
#include <linux/timer.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/mm.h>
#include <asm/io.h>
#include <comedi_module.h>
#include <config.h>

comedi_devinit dummy_init,
	dt2811_init,
	dt2801_init,
	dt2814_init,
	dt2817_init,
	dt282x_init,
	atmio_E_init,
	pcimio_E_init,
	atmio16f_init,
	ssc31_init,
	dev_8255_init,
	das08_init,
	pcl711_init,
	pcl725_init,
	pcl726_init,
	rti800_init,
	rti802_init,
	rti860_init,
	parport_init,
        acl8112_init,
        das1600_init,
	das08jr_init,
        multiq3_init,
        dt2815_init,
        dt3000_init,
	das16_init,
	xxx_init;

comedi_devinit *comedi_devinits[]={
/* dummy driver */
	dummy_init,
#ifdef CONFIG_DT2801
/* Data Translation DT2801 board */
	dt2801_init,
#endif
#ifdef CONFIG_DT2811
/* Data Translation DT2811 board */
	dt2811_init,
#endif
#ifdef CONFIG_DT2814
/* Data Translation DT2814 board */
	dt2814_init,
#endif
#ifdef CONFIG_DT2817
/* Data Translation DT2817 board */
	dt2817_init,
#endif
#ifdef CONFIG_DT282x
/* Data Translation DT2821 series boards */
	dt282x_init,
#endif
#ifdef CONFIG_DT3000
/* Data Translation DT3000 series boards */
	dt3000_init,
#endif
#ifdef CONFIG_8255
/* generic 8255 */
	dev_8255_init,
#endif
#ifdef CONFIG_ATMIO_E
/* National Intruments NI-DAQ AT-MIO E series */
	atmio_E_init,
#endif
#ifdef CONFIG_PCIMIO_E
/* National Intruments NI-DAQ PCI-MIO E series */
	pcimio_E_init,
#endif
#ifdef CONFIG_NI_F
/* National Intruments NI-DAQ AT-MIO, Am9513 based */
	ni_F_init,
#endif
#ifdef CONFIG_SSC31
/* Spectrum Signal Processing, Inc. PC/C31 Real Time Application board */
	ssc31_init,
#endif
#ifdef CONFIG_DAS08
/* DAS-08 driver for Keithley Metrabyte, Computer Boards */
	das08_init,
#endif
#ifdef CONFIG_PCL711
/* PCL-711 PC-LabCard */
	pcl711_init,
#endif
#ifdef CONFIG_PCL725
/* pcl 725 and compatibles */
	pcl725_init,
#endif
#ifdef CONFIG_PCL726
/* PCL-726 PC-LabCard */
	pcl726_init,
#endif
#ifdef CONFIG_RTI800
/* Analog Devices RTI800/815 */
	rti800_init,
#endif
#ifdef CONFIG_RTI802
/* Analog Devices RTI802 */
	rti802_init,
#endif
#ifdef CONFIG_RTI860
	rti860_init,
#endif
#ifdef CONFIG_COMEDI_PARPORT
/* Parallel port */
	parport_init,
#endif
#ifdef CONFIG_DAS08JR
/* DAS-08jr driver for Keithley Metrabyte, Computer Boards */
	das08jr_init,
#endif
#ifdef CONFIG_DAS1600
/* DAS-1600 driver for Keithley Metrabyte, Computer Boards */
	das1600_init,
#endif
#ifdef CONFIG_MULTIQ3
/* MultiQ-3 driver for Quanser Consulting MultiQ-3 board. */
	multiq3_init,
#endif
#ifdef CONFIG_DT2815
/* Data Translation DT2815 series board. */
       dt2815_init,
#endif
#ifdef CONFIG_DAS16
/* DAS-16 driver for Keithley Metrabyte, Computer Boards */
	das16_init,
#endif
#ifdef CONFIG_DAS16
/* National Instruments PCI-DIO-96 */
	nidio96_init,
#endif
#ifdef CONFIG_VD_XXX
/* virtual driver XXX */
	xxx_init,
#endif
	NULL
};

const int comedi_maxinits=sizeof(comedi_devinits)/sizeof(comedi_devinit *)-1;

