/*
 *  rt_printk.c, hacked from linux/kernel/printk.c
 *
 * Modified for RT support, David Schleef
 */

#ifndef __RT_PRINTK_H
#define __RT_PRINTK_H

#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
#ifndef RTL_V1
#define RTL_V1
#endif
#else
#ifndef RTL_V2
#define RTL_V2
#endif
#endif

#define HAVE_RT_PRINTK

#ifdef RTL_V1
#define rt_printk(format,args...)
#define rt_printk_cleanup()
#define rt_printk_init()	0
#endif

#ifdef RTL_V2

int rt_printk(const char *fmt, ...);

void rt_printk_cleanup(void);
int rt_printk_init(void);

#endif

#endif

