/*
 */

#include <comedi_module.h>

#ifdef HAVE_RTL_POSIXIO

#include <linux/errno.h>
#include <rtlinux/rtl_posixio.h>


static ssize_t comedi_rtl_read(struct rtl_file *file,char *buf,
	size_t len,loff_t *p)
{
	return -EIO;
}

static ssize_t comedi_rtl_write(struct rtl_file *file,const char *buf,
	size_t len,loff_t *p)
{
	return -EIO;
}

static int comedi_rtl_ioctl(struct rtl_file *file,unsigned int cmd,
	unsigned long arg)
{
	switch(cmd){
	case COMEDI_TRIG:
	  {
		comedi_trig *it=(comedi_trig *)arg;
		int minor=file->f_minor;
		int subdev=it->subdev;

		return comedi_trig_ioctl(minor,subdev,it);
	  }
	case COMEDI_LOCK:
	  {
		int minor=file->f_minor;
		int subdev=(int)arg;

		return comedi_lock_ioctl(minor,subdev);
	  }
	case COMEDI_UNLOCK:
	  {
		int minor=file->f_minor;
		int subdev=(int)arg;

		return comedi_lock_ioctl(minor,subdev);
	  }
	case COMEDI_CANCEL:
	  {
		int minor=file->f_minor;
		int subdev=(int)arg;

		return comedi_cancel_ioctl(minor,subdev);
	  }
	}

	return -EIO;
}

static int comedi_rtl_open(struct rtl_file *file)
{
	return 0;
}

static int comedi_rtl_release(struct rtl_file *file)
{
	return 0;
}


struct rtl_file_operations comedi_rtl_fops={
	read:		comedi_rtl_read,
	write:		comedi_rtl_write,
	ioctl:		comedi_rtl_ioctl,
	open:		comedi_rtl_open,
	release:	comedi_rtl_release,
};

#endif

