/*
    rtl_compat.h
    Real-Time Linux compatibility header file

    Copyright (C) 1998-9 David A. Schleef <ds@stm.lbl.gov>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/*
   Portions taken from Don Becker's network device drivers, and
   modified.
*/

/*
   The purpose of this file is to make it easy to write modules
   that will compile correctly for multiple kernel versions.
   This file can only provide backward compatibility, i.e.,
   write your driver for 2.3.x, include this header file, and
   theoretically, it will compile and run on 2.0.37.  However,
   some interface changes require superset definitions to
   allow compilation for all supported kernel versions, so
   you have to use the interface provided in this file to
   compile for all kernels.

   If your driver is written for the 2.2.x interface, define
   COMPAT_V22 before including this file.
*/

#ifndef _RTL_COMPAT_H
#define _RTL_COMPAT_H

#define HAVE_RTL_COMPAT

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
#define RTL_V1
#else
#define RTL_V2
#endif

#ifdef RTL_V1
/* RTL 1.1 */
#include <asm/rt_irq.h>

#define rtl_request_global_irq(irq,handler) request_RTirq(irq,handler)
#define rtl_free_global_irq(irq) free_RTirq(irq)

#define rtl_request_local_irq(a,b,c) rtl_request_local_irq_not_available
#define rtl_free_local_irq(a) rtl_free_local_irq_not_available

#define rtl_printf(args...)

#endif


#ifdef RTL_V2
/* RTL 2.2 */

#include <linux/rtl.h>

#undef HAVE_RTL_POSIXIO

#endif



#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,0)	/* XXX */

/* this needs to be fixed */

#define rt_claim_dma_lock()
#define rt_release_dma_lock()

#endif


#endif /* _KERN_COMPAT_H */




